/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

public class Astroformat {
    public String[] nulls;
    public static final int DECIMAL = 0;
    public static final int EFORMAT = 1;
    public static final int FACTOR = 10;
    public static final int SEXA2 = 2;
    public static final int SEXA3 = 3;
    public static final int SEXA2c = 4;
    public static final int SEXA3c = 5;
    public static final int SEXA2d = 6;
    public static final int SEXA3d = 7;
    public static final int SEXA2h = 8;
    public static final int SEXA3h = 9;
    public static final int SEXA1d = 11;
    public static final int SEXA1h = 12;
    public static final int SEXA1o = 13;
    public static final int SEXA2o = 14;
    public static final int SEXA3o = 15;
    public static final int DATE = 128;
    public static final int DATE_alpha = 129;
    public static final int DATE_YM = 128;
    public static final int DATE_MY = 130;
    public static final int DATE_YD = 132;
    public static final int DATE_DY = 134;
    public static final int DATE_YMD = 136;
    public static final int DATE_DMY = 138;
    public static final int DATE_MDY = 140;
    public static final int DATE_MYD = 142;
    public static final int DATE_DIFF = 133;
    public static final int SIGN_EDIT = 16;
    public static final int ZERO_FILL = 32;
    public static final int TRUNCATE = 64;
    public static final int DATE_COMP = 128;
    protected static final String pic1 = "YMDhmsymDdMS";
    protected static final String[] pic1_explain = new String[]{"Year", "Month", "Day", "hour", "minute", "second", "year", "month", "day", "degree", "Minute", "Second"};
    public static String[] month_list = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final byte[] properties = new byte[]{0, 0, 16, 16, 16, 16, 18, 18, 17, 17, 0, 2, 1, 2, 18, 18};
    private static final String[] explain_form = new String[]{"decimal", "E-format", "sexa(h,m)", "sexa(h,m,s)", "sexa(h:m)", "sexa(h:m:s)", "sexa_d_m", "sexa_d_m_s", "sexa_h_m", "sexa_h_m_s", "x10-format", "decimal_d", "decimal_h", "decimal_\u00b0", "sexa_\u00b0_'", "sexa_\u00b0_'_\""};
    private static final String[] explain_date = new String[]{"date(YM)", "date(Ymon)", "date(MY)", "date(monY)", "date(YD)", "#mjd-5#", "date(DY)", "#mjd-7#", "date(YMD)", "date(YmonD)", "date(DMY)", "date(DmonY)", "date(MDY)", "date(monDY)", "date(MYD)", "date(monYD)"};
    private static final String[] explain_pec = new String[]{"", ",signed", ",zero-filled", ",signed,zero-filled"};

    public static final String explain(int n) {
        int n2 = n & 0xFF;
        String string = (n2 & 0x80) != 0 ? explain_date[n2 & 0xF] : explain_form[n2 & 0xF];
        return string + explain_pec[n2 >> 4 & 3];
    }

    public static final boolean isSexa(int n) {
        return (properties[n & 0xF] & 0x10) != 0;
    }

    public static final boolean isDate(int n) {
        return (n & 0x80) != 0 && !Astroformat.isDays(n);
    }

    public static final boolean isDays(int n) {
        return (n & 0x8F) == 133;
    }

    public static final boolean isTime(int n) {
        return (properties[n & 0xF] & 1) != 0;
    }

    public static final boolean isAngle(int n) {
        return (properties[n & 0xF] & 2) != 0;
    }

    public static final String explainComplex(String string) {
        int n;
        char c;
        int n2;
        StringBuffer stringBuffer = new StringBuffer(128);
        char[] cArray = new char[6];
        char[] cArray2 = string.toCharArray();
        int n3 = string.length();
        int n4 = 0;
        cArray[5] = '\u0000';
        cArray[4] = '\u0000';
        cArray[3] = '\u0000';
        cArray[2] = '\u0000';
        cArray[1] = '\u0000';
        cArray[0] = '\u0000';
        while (n4 < n3) {
            if ((n2 = pic1.indexOf(c = cArray2[n4++])) < 0) continue;
            n = 1;
            while (n4 < n3 && cArray2[n4] == c) {
                ++n;
                ++n4;
            }
            cArray[n2 % 6] = Character.toLowerCase(c);
        }
        stringBuffer.append("Complex ");
        if (cArray[0] != '\u0000') {
            stringBuffer.append("date");
        } else if (cArray[2] != '\u0000' || cArray[3] == 'h') {
            stringBuffer.append("time");
        } else {
            stringBuffer.append("angle");
        }
        stringBuffer.append(" made of:");
        n4 = 0;
        while (n4 < n3) {
            if ((n2 = pic1.indexOf(c = cArray2[n4++])) < 0 && c != 'f') continue;
            stringBuffer.append(' ');
            if (n2 < 0) {
                stringBuffer.append("and fraction");
            } else {
                stringBuffer.append(pic1_explain[n2]);
            }
            n = 1;
            while (n4 < n3 && cArray2[n4] == c) {
                ++n;
                ++n4;
            }
        }
        return stringBuffer.toString();
    }

    public Astroformat() {
        this.setNaN("---");
    }

    public Astroformat(String string) {
        this.setNaN(string);
    }

    public void setNaN(String string) {
        this.nulls = new String[2];
        this.nulls[0] = string;
        this.nulls[1] = null;
    }

    public void acceptAsNaN(String string) {
        int n = this.nulls.length - 1;
        if (this.nulls[n] != null) {
            String[] stringArray = new String[++n + 2];
            System.arraycopy(this.nulls, 0, stringArray, 0, n);
            this.nulls = stringArray;
            this.nulls[n + 1] = null;
        }
        this.nulls[n] = string;
    }
}

